{ Turbo Pascal Interface for Derivative Bit Stream Play routine.
  Play routine written by Alan D. Jones, modified by Daniel B. Singer.
  Interface by Daniel B. Singer}

unit bitsound;

Interface

type
  soundPtr   = ^soundRec;
  soundRec = record
               dataPointer : ^byte;
               soundLength  : word
             end;
  soundPath  = string [64];

procedure playSound (dataPtr : soundPtr);
procedure loadSound (fileName : soundPath; var dataPtr : soundPtr);
procedure purgeSound (var dataPtr : soundPtr);

Implementation

procedure loadSound (fileName : soundPath; var dataPtr : soundPtr);
  var
    f : file;

  begin
    assign (f, fileName);
    {$i-}
    reset (f, 1);
    {$i+}
    if (ioResult = 0) then
      begin
        new (dataPtr);
        dataPtr^.soundLength := fileSize (f);
        with dataPtr^ do
          getMem (dataPointer, soundLength);
        with dataPtr^ do
          blockRead (f, dataPointer^, soundLength, soundLength)
      end
    else
      dataPtr := nil;
    close (f)
  end; {loadSound}

procedure purgeSound (var dataPtr : soundPtr);
  begin
    with dataPtr^ do
      freeMem (dataPointer, soundLength);
    dispose (dataPtr);
    dataPtr := nil
  end;

procedure Play (DataPtr : pointer; dataLenth : word); EXTERNAL;
					 {$L \pascal\stsPlay.obj     link in object module}

{dummy procedure shell used so play.obj procedure is a NEAR call}

procedure playSound (dataPtr : soundPtr);
  begin
    with dataPtr^ do
      play (dataPointer, soundLength)
  end;


begin
  writeln (' BitStream Digital Sound Unit Installed ͸');
  writeln ('         Concept by Alan D. Jones         ');
  writeln ('   Pascal Interface by Daniel B. Singer   ');
  writeln (';');
  writeln
end.


